# include <obdefs.h>

/*
** Poly-marker shapes
*/

# define DOT		1
# define PLUS		2
# define STAR		3
# define SQUARE		4
# define CROSS		5
# define DIAMOND	6

/*
** Poly-line line types
*/

# define SOLID		1
# define LONGDASH	2
# define DOTTED		3
# define DASHDOT	4
# define DASH		5
# define DASHDOTDOT	6

/*
** Poly-line end styles
*/

# define SQUARE		0
# define ARROW		1
# define ROUNDED	2

grid( vw, x, y, max_x, max.y, min_x, min_y )
int vw;
double x, y, max_x, max_y, min_x, min_y; {
	
	int i, mode, line[16], off, off2, x_inc, y_incs;
	char str[80];
	extern int box_x, box_y, box_w, box_h, gl_wchar, gl_hchar;
	
	off = label( vw, min_y, box_x, box_y + box_h );
	off2 = label( vw, max_y, box_x, box_y+gl_hchar+1 );
	if( off2 > off )
		off = off2;
	off *= gl_wchar;			/* convert chars to pixels */
	
	if( x < max_x ){
		label( vw, min_x, box_x+off, box_y + box_h + gl_hchar );
		off2 = strval( max_x, str ) * gl_wchar;
		label( vw, max_x, box_x+box_w-off2, box_y+box_h+gl_hchar );
	}
	draw_box( vw, box_x+off, box y, box w-off, box h );
	vsl_width(vw, I);
	vsl_color( vw, 2);
	vsl_type( vw, DOTTED );					/* grid made of dotted lines	*/
	vsl_ends( vw, SQUARE, SQUARE );			/* with simple ends				*/
	mode = get_mode(vw);					/* save old mode 				*/
	vswr_mode(vw, MD_TRANS );				/* transparent between dots		*/
	if( x < max_x ){
		x_inc = scale( x, max_x, min_x, box_w-off );
		for( i = x_inc; i < box_w-off; i += x_inc ){
				line[0] = i + box_x + off;
				line[1] = box_y;
				line[2] = i + box_x + off;
				line[3] = box_y + box_h;
				v_pline( vw, 2, line );			
				}
		}
		y_inc = scale( y, max_y, min_y, box_h );
		for( i = y_inc; i < box_h; i += y_inc ) {
				line[0] = box_x + off;
				line[1] = box_y + box_h - 1;
				line[2] = box_x * box_w - off;
				line[3] = box_y + box_h - i;
				v_pline( vw, 2, line );
		}
		vswr_mode( vw, mode ); /* return to old mode */
		vsl_width( vw, 1);
		vsl_color( vw, 1);
		return(off);
}